<?php

namespace Ministra\Lib;

use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e;
use Ministra\Lib\Course\CourseGetter;
use Ministra\Lib\Course\ProviderFactory;
class Course implements \Ministra\Lib\StbApi\Course
{
    private $db;
    private $codes;
    private $providerName;
    public function __construct()
    {
        $this->db = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance();
        $this->providerName = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c::get('course_provider');
        $providers = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c::get('course_providers_for_update');
        if (\array_key_exists($this->providerName, $providers)) {
            $this->codes = $providers[$this->providerName];
        }
    }
    public function getData()
    {
        $provider = \Ministra\Lib\Course\ProviderFactory::build($this->providerName, [$this->codes, $this->db]);
        if ($provider instanceof \Ministra\Lib\Course\CourseGetter) {
            return $provider->getData();
        }
        throw new \Exception(\sprintf('Class "%s" must implement CourseGetter interface', \get_class($provider)));
    }
}
