<?php

namespace Ministra\Lib;

use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\f1346478e91df21aff77c1e1db9ef4c7;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e;
class Event extends \Ministra\Lib\HTTPPush
{
    public static $allowed_events = array('send_msg', 'reboot', 'reload_portal', 'update_channels', 'play_channel', 'play_radio_channel', 'mount_all_storages', 'cut_off', 'update_image', 'update_epg', 'update_subscription', 'update_modules', 'cut_on', 'show_menu', 'additional_services_status', 'send_msg_with_video', 'send_msg_with_url');
    private $param = array('user_list' => array(), 'event' => '', 'header' => '', 'priority' => 0, 'msg' => '', 'need_confirm' => 0, 'reboot_after_ok' => 0, 'eventtime' => 0, 'auto_hide_timeout' => 0, 'param1' => '', 'post_function' => '');
    private $pattern;
    private $db;
    private $ttl;
    public function __construct()
    {
        $this->db = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance();
        $this->pattern = $this->param;
    }
    public static function setSended($id)
    {
        $db = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance();
        $db->update('events', ['sended' => 1], ['id' => $id]);
    }
    public static function setConfirmed($id)
    {
        $db = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance();
        $db->update('events', ['confirmed' => 1, 'ended' => 1], ['id' => $id]);
    }
    public static function setEnded($id)
    {
        $db = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance();
        $db->update('events', ['ended' => 1], ['id' => $id]);
    }
    public static function getAllNotEndedEvents($uid)
    {
        if ($uid) {
            $db = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance();
            return $db->from('events')->where(['uid' => $uid, 'ended' => 0, 'eventtime>' => \date(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::f7c1a00e2e85e35c3eab86d1e76eefa5)])->orderby('priority')->orderby('addtime')->get()->all();
        }
        return false;
    }
    public function setUserListByMac($list)
    {
        if (\is_string($list) || \is_int($list)) {
            if ($list == 'all') {
                $this->param['user_list'] = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\f1346478e91df21aff77c1e1db9ef4c7::Y8fbfe3a20400cb6832db68ebaf4dd406();
            } elseif ($list == 'online') {
                $this->param['user_list'] = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\f1346478e91df21aff77c1e1db9ef4c7::f361ecbb283b26c9d3a0143f742dd591();
            } else {
                $this->param['user_list'] = [\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\f1346478e91df21aff77c1e1db9ef4c7::e010d9b8e66727fd5a0124a4e75dbda5($list)];
            }
        } else {
            $this->param['user_list'] = [];
            foreach ($list as $mac) {
                $this->param['user_list'][] = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\f1346478e91df21aff77c1e1db9ef4c7::e010d9b8e66727fd5a0124a4e75dbda5($mac);
            }
        }
    }
    public function setUserListById($list)
    {
        if (\is_string($list) || \is_int($list)) {
            if ($list == 'all') {
                $this->param['user_list'] = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\f1346478e91df21aff77c1e1db9ef4c7::Y8fbfe3a20400cb6832db68ebaf4dd406();
            } else {
                $this->param['user_list'] = [$list];
            }
        } else {
            $this->param['user_list'] = $list;
        }
    }
    public function setAutoHideTimeout($timeout)
    {
        $this->param['auto_hide_timeout'] = $timeout;
    }
    public function setTtl($ttl)
    {
        $this->ttl = (int) $ttl;
    }
    protected function setEvent($event)
    {
        $this->param['event'] = $event;
    }
    protected function setMsg($msg)
    {
        $this->param['msg'] = $msg;
    }
    protected function setHeader($header = '')
    {
        $this->param['header'] = $header;
    }
    protected function setParam1($param1)
    {
        $this->param['param1'] = $param1;
    }
    protected function setPostFunction($post_function)
    {
        $this->param['post_function'] = $post_function;
    }
    protected function setNeedConfirm($need_confirm)
    {
        $this->param['need_confirm'] = $need_confirm;
    }
    protected function setRebootAfterOk($reboot_after_ok)
    {
        $this->param['reboot_after_ok'] = $reboot_after_ok;
    }
    protected function send()
    {
        if (!$this->param['eventtime']) {
            if (empty($this->ttl)) {
                if ($this->param['event'] == 'send_msg' || $this->param['event'] == 'send_msg_with_video') {
                    $this->ttl = 7 * 24 * 3600;
                } else {
                    $this->ttl = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c::get('watchdog_timeout') * 2;
                }
            }
            $this->setEventTime(\date('Y-m-d H:i:s', \time() + $this->ttl));
        }
        if (!$this->param['priority']) {
            if ($this->param['event'] == 'send_msg' || $this->param['event'] == 'send_msg_with_video') {
                $this->setPriority(2);
            } else {
                $this->setPriority(1);
            }
        }
        $this->saveInDb();
        $this->push();
        $this->resetEventOptions();
    }
    protected function setEventTime($eventtime)
    {
        $this->param['eventtime'] = $eventtime;
    }
    protected function setPriority($priority)
    {
        $this->param['priority'] = $priority;
    }
    protected function saveInDb()
    {
        if (\is_array($this->param['user_list']) && \count($this->param['user_list']) > 0) {
            $data = [];
            foreach ($this->param['user_list'] as $uid) {
                $data[] = ['uid' => $uid, 'event' => $this->param['event'], 'header' => $this->param['header'], 'addtime' => 'NOW()', 'eventtime' => $this->param['eventtime'], 'need_confirm' => $this->param['need_confirm'], 'reboot_after_ok' => $this->param['reboot_after_ok'], 'msg' => $this->param['msg'], 'priority' => $this->param['priority'], 'auto_hide_timeout' => $this->param['auto_hide_timeout'], 'param1' => $this->param['param1'], 'post_function' => $this->param['post_function']];
                if ($this->param['event'] == 'cut_off') {
                    \Ministra\Lib\v6a16e956669a34c31b2f973a961093ff\e3ba4dfefbda5a0232f6e03118bcf94bd::cced0fb66fceddbb9053c4137a133f10($uid);
                }
            }
            if ($this->param['event'] == 'send_msg' && $this->param['reboot_after_ok'] == 1) {
                \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->query('delete from events where uid in(' . \implode(',', $this->param['user_list']) . ') and event="send_msg" and sended=0 and reboot_after_ok=1');
            }
            $this->db->insert('events', $data);
        }
    }
    protected function resetEventOptions()
    {
        $this->param = $this->pattern;
    }
}
