<?php

namespace Ministra\Lib;

use ErrorException;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\U7b1423316998af8498523ab49b7053e6\db80ff00c5c6895fbc557478d8cbe1d3;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e;
class Storage
{
    private $storage;
    private $max_failures;
    private $stat_period;
    public function __construct($init_info = array())
    {
        if (empty($init_info)) {
            return;
        }
        if (!empty($init_info['id'])) {
            $this->storage = $this->getById($init_info['id']);
        } else {
            if (!empty($init_info['name'])) {
                $this->storage = $this->getByName($init_info['name']);
            }
        }
        if (empty($this->storage)) {
            throw new \ErrorException('Storage can not be initialized with values: ' . \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\U7b1423316998af8498523ab49b7053e6\db80ff00c5c6895fbc557478d8cbe1d3::J5715a28eab82f0683cffac69f04eb80d($init_info));
        }
        $this->max_failures = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c::getSafe('max_storage_failures', 3);
        $this->stat_period = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c::getSafe('storage_stat_period', 300);
    }
    public function getById($id)
    {
        return \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->from('storages')->where(['id' => $id])->get()->first();
    }
    public function getByName($name)
    {
        return \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->from('storages')->where(['storage_name' => $name])->get()->first();
    }
    public function markAsFailed($description = '')
    {
        $this->checkIfInitialized();
        \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->insert('storages_failure', ['storage_id' => $this->storage['id'], 'description' => $description])->insert_id();
        $failures = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->from('storages_failure')->count()->where(['storage_id' => $this->storage['id'], 'added>' => \date('Y-m-d H:i:s', \time() - $this->stat_period)])->get()->counter();
        if ($failures >= $this->max_failures) {
            $this->setOff();
        }
    }
    private function checkIfInitialized()
    {
        if (empty($this->storage)) {
            throw new \ErrorException('Storage not initialized');
        }
        return true;
    }
    public function setOff()
    {
        $this->checkIfInitialized();
        if ($this->storage['status'] == 0) {
            return true;
        }
        $result = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->update('storages', ['status' => 0], ['id' => $this->storage['id']]);
        if ($result) {
            \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->insert('master_log', ['log_txt' => 'Storage ' . $this->storage['storage_name'] . ' has been disabled after ' . $this->max_failures . ' failures in ' . $this->stat_period . 's', 'added' => 'NOW()']);
        }
        return $result;
    }
}
